/*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:09:38 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_SEP_ATP_SpecialData.c#1:csrc:1
   *  \author taniam
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ***********************************/
#include "stdio.h"
#include "SST_SEP_TST.h"
#include "CRYS_SST.h"
#include "SEP_ATP_UTIL_funcs.h"


extern TST_ATP_SpecialDataOpAESTestDataStruct* TST_ATP_SpecialDataOpAESTestData;
extern TST_ATP_SpecialDataOpDESTestDataStruct* TST_ATP_SpecialDataOpDESTestData;
/*****************************************************************************
 * Function Name:
 *  SEPQA_SST_SpecialDataOpAES
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 * Test the Test the insertion, generation, reading, deletion, and usage of an AES symmetric key.
 *  
 * Algorithm:       
 *    1.    Create a new session by calling: SST_SessionCreate.
 *    2.    Open a transaction by calling: SST_TransactionStart.
 *    3.    Create a new AES shared key authenticator by calling: SST_ AuthenticatorAESSharedSecretCreate.
 *    4.    Open the authenticator by calling:
 *          i.      SST_AuthenticatorChallengeGet 
 *          ii.      CRYS_AES (Encrypt the challenge using the AES key)
 *          iii.  SST_AuthenticationOpen.
 *    5.  Close the transaction by calling: SST_TransactionClose.
 *    6.  Open a transaction by calling: SST_TransactionStart.
 *    7.  Create a new AES #1 key by calling: SST_AESKeyGenerate.
 *    8.  Read the generated AES key #1 by calling: SST_AESKeyRead.
 *    9.  Insert an AES #2 key to the SST by calling: SST_AESKeyInsert. Using the data received by reading the SST key #1
 *    10.  Read the inserted AES key #2 by calling: SST_AESKeyRead. And compare to data used.
 *    11.  Close the transaction by calling: SST_TransactionEnd.
 *    12.  Encrypt plain text by using AES key #1 and calling: CRYS_SST_AES.
 *    13.  Decrypt the received cipher text using AES key #2 by calling: CRYS_SST_AES and compare to the original plain text.
 *    14.  Open a transaction by calling: SST_TransactionStart.
 *    15.  Delete the AES keys (one by one) by calling: SST_DataDelete.
 *    16.  Close the authenticator by calling: SST_AuthenticationClose.
 *    17.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    18.  Close the transaction by calling: SST_TransactionClose.
 *    19.  Delete the session by calling: SST_SessionDelete.
 *
 *******************************************************************************/    
DxError_t SEPQA_SST_SpecialDataOpAES ( void )
{ 
     /********* TST Variables Definitions ************/
     DxUint32_t                  TST_index=0;
     DxChar                      TST_MasterTestName[TST_FUNC_STRING_LEN] = "SEPQA_SST_ATP_SpecialDataOpAES";
     SSTSessionId_t              TST_SessionId; 
     SSTTxnId_t                  TST_TransactionId;
     SSTHandle_t                 TST_AuthHandle,TST_AESKeyHandle1,TST_AESKeyHandle2;
     SSTChallengeId_t            TST_ChallengeId;
     SSTDataType_t               TST_AESKeyData = TST_AESKEY_OBJECT;
     CRYS_AES_EncryptMode_t      TST_CRYS_AES_EncryptMode;
     DxError_t                TST_Status = DX_FAILURE;
     /********* TST Variables initialization *********/

     TST_AuthHandle.objId = SST_HANDLE_RANDOM_GENERATE; 
     TST_AESKeyHandle1.objId = SST_HANDLE_RANDOM_GENERATE;
     TST_AESKeyHandle2.objId = SST_HANDLE_RANDOM_GENERATE;


     /************************************************/
     /*********** Start of test **********************/
     /************************************************/

    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," *********** SEPQA_SST_ATP_SpecialDataOpAES Tests ***************** \n"));     
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************************** \n \n"));


    ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using internal handles          \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));



     /* Create a session for operations */
     /*---------------------------------*/
     TST_Status = SST_SessionCreate(&TST_SessionId);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);


     /* Open a transaction for operations */
     /*-----------------------------------*/
     TST_Status = SST_TransactionStart(&TST_TransactionId);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);


     /* Create a new AES shared key authenticator */
     /*-------------------------------------------*/
     TST_Status = SST_AuthenticatorAESSharedSecretCreate(TST_TransactionId,
                                                        TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AuthenticatorAESKey,
                                                        SST_KEY_TYPE_AES_128_BIT,
                                                       &TST_AuthHandle,
                                                        TST_Workspace,
                                                        TST_WorkspaceSizeInBytes);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorAESSharedSecretCreate",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);


     /* Open the authentication */
     /*-------------------------*/
     /* Get the challenge*/
     TST_Status = SST_AuthenticatorChallengeGet(TST_ATP_SpecialDataOpAESTestData[TST_index].TST_ChallengeBuff,
                                                TST_ATP_SpecialDataOpAESTestData[TST_index].TST_ChallengeBuffSize,  
                                                &TST_ChallengeId);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorChallengeGet",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);


     /* Encrypt the challenge using the AES key */
     TST_Status = CRYS_AES(DX_NULL,
                           TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AuthenticatorAESKey,
                           CRYS_AES_Key128BitSize,
                           CRYS_AES_Encrypt,
                           CRYS_AES_ECB_mode,
                           TST_ATP_SpecialDataOpAESTestData[TST_index].TST_ChallengeBuff,
                           TST_ATP_SpecialDataOpAESTestData[TST_index].TST_ChallengeBuffSize,
                           TST_ATP_SpecialDataOpAESTestData[TST_index].TST_EncChallengeBuff);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_AES",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);


     /* Close the transaction */
     /*-----------------------*/
   
     TST_Status = SST_TransactionEnd(TST_TransactionId,
                                     DX_TRUE,/*reflash sensitive*/
                                     TST_Workspace,
                                     TST_WorkspaceSizeInBytes);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);


     /* Open the authenticator */
     TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                         TST_AuthHandle,
                                         TST_ATP_SpecialDataOpAESTestData[TST_index].TST_EncChallengeBuff,
                                         TST_ATP_SpecialDataOpAESTestData[TST_index].TST_ChallengeBuffSize,
                                         TST_ChallengeId,
                                         TST_Workspace,
                                         TST_WorkspaceSizeInBytes);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen - AES",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);


     /* Open a transaction for operations */
     /*-----------------------------------*/
     TST_Status = SST_TransactionStart(&TST_TransactionId);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);


     /* Create a new AES key #1 */
     /*-------------------------*/
     TST_Status = SST_AESKeyGenerate(TST_TransactionId,
                                     TST_SessionId,
                                     TST_AuthHandle,
                                     TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AESKeyType1,
                                     TST_AESKeyData,
                                     &TST_AESKeyHandle1,
                                     TST_Workspace,
                                     TST_WorkspaceSizeInBytes);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AESKeyGenerate",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);


     /* Verify the type of AES key #1 */
     /*-------------------------------*/
     TST_Status = SST_AESKeyRead(TST_SessionId,
                                 TST_AESKeyHandle1,
                                 TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AESKey2,
                                 &TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AESKeyType2,
                                 TST_Workspace,
                                 TST_WorkspaceSizeInBytes);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AESKeyRead - Get key type",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);



      if (TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AESKeyType2 != TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AESKeyType1)
             TST_Status = DX_FALSE;

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Validate key type - AES",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);



     /* Insert AES Key #2 */
     /*-------------------*/
     TST_Status = SST_AESKeyInsert(TST_TransactionId,
                                   TST_SessionId,
                                   TST_AuthHandle,
                                   TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AESKey2,
                                   TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AESKeyType2,
                                   TST_AESKeyData,
                                   &TST_AESKeyHandle2,
                                   TST_Workspace,
                                   TST_WorkspaceSizeInBytes);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AESKeyInsert - Key #2",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);


     /* Read AES key #2 */
     /*-----------------*/
     TST_Status = SST_AESKeyRead(TST_SessionId,
                                 TST_AESKeyHandle2,
                                 TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AESKeyTemp,
                                 &TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AESKeyTypeTemp,
                                 TST_Workspace,
                                 TST_WorkspaceSizeInBytes);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AESKeyRead #2",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);


     /* Compare the retrieved key to inserted one */
     /*-------------------------------------------*/
     if(!DX_VOS_MemCmp(TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AESKey2,
                       TST_ATP_SpecialDataOpAESTestData[TST_index].TST_AESKeyTemp,
                       TST_ATP_SpecialDataOpAESTestData[TST_index].TST_KeySizeInBytes))
        TST_Status = TESTPASS; /*Data Buffers are the same*/
     else
        TST_Status = TESTFAIL; /*Data Buffers are different*/

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - keys",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);


     /* Close the transaction */
     /*-----------------------*/
     TST_Status = SST_TransactionEnd(TST_TransactionId,
                                     DX_TRUE,/*reflash sensitive*/
                                     TST_Workspace,
                                     TST_WorkspaceSizeInBytes);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);



     /* Encrypt a block of data using key #1 */
     /*--------------------------------------*/

     TST_Status = CRYS_SST_AES(TST_AESKeyHandle1,
                               TST_SessionId,
                               TST_ATP_SpecialDataOpAESTestData[TST_index].TST_IVCounter,
                               CRYS_AES_Encrypt, 
                               TST_ATP_SpecialDataOpAESTestData[TST_index].TST_OperationMode,
                               TST_ATP_SpecialDataOpAESTestData[TST_index].TST_DataIn,
                               TST_ATP_SpecialDataOpAESTestData[TST_index].TST_DataInSize,
                               TST_ATP_SpecialDataOpAESTestData[TST_index].TST_DataOut,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_AES - Encrypt",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);


     /* Decrypt the block of data using key #2 */
     /* In case using CTR we use Encrypt again */
     /*----------------------------------------*/
     if (TST_ATP_SpecialDataOpAESTestData[TST_index].TST_OperationMode == CRYS_AES_CTR_mode)
         TST_CRYS_AES_EncryptMode = CRYS_AES_Encrypt;
     else
         TST_CRYS_AES_EncryptMode = CRYS_AES_Decrypt;

     TST_Status = CRYS_SST_AES(TST_AESKeyHandle2,
                              TST_SessionId,
                              TST_ATP_SpecialDataOpAESTestData[TST_index].TST_IVCounter,
                              TST_CRYS_AES_EncryptMode, 
                              TST_ATP_SpecialDataOpAESTestData[TST_index].TST_OperationMode,
                              TST_ATP_SpecialDataOpAESTestData[TST_index].TST_DataOut,
                              TST_ATP_SpecialDataOpAESTestData[TST_index].TST_DataInSize,
                              TST_ATP_SpecialDataOpAESTestData[TST_index].TST_DataOutDecrypt,
                              TST_Workspace,
                              TST_WorkspaceSizeInBytes);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_AES - Decrypt",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);


     /* Compare the decrypted data to original one */
     /*--------------------------------------------*/
     if(!DX_VOS_MemCmp(TST_ATP_SpecialDataOpAESTestData[TST_index].TST_DataIn,
               TST_ATP_SpecialDataOpAESTestData[TST_index].TST_DataOutDecrypt,
               TST_ATP_SpecialDataOpAESTestData[TST_index].TST_DataInSize))
        TST_Status = TESTPASS; /*Data Buffers are the same*/
    else
        TST_Status = TESTFAIL; /*Data Buffers are different*/

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - Decrypted data",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);



      /* Open a transaction for operations */
      /*-----------------------------------*/
      TST_Status = SST_TransactionStart(&TST_TransactionId);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);


      /* Delete the AES keys */
      /*---------------------*/
      TST_Status = SST_DataDelete(TST_TransactionId,
                                 TST_SessionId,  
                                 TST_AESKeyHandle1,
                                 TST_Workspace,
                                 TST_WorkspaceSizeInBytes);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - AES key #1",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);


     TST_Status = SST_DataDelete(TST_TransactionId,
                                TST_SessionId,  
                                TST_AESKeyHandle2,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - AES key #2",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);


     /* Close the authentication */
     /*--------------------------*/
     TST_Status = SST_AuthenticationClose(TST_SessionId,TST_AuthHandle);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationClose",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);


     /* Delete the authenticator */
     /*--------------------------*/
     TST_Status = SST_AuthenticatorDelete(TST_TransactionId,
                                          TST_AuthHandle);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);



     /* Close the transaction */
     /*-----------------------*/
     TST_Status = SST_TransactionEnd(TST_TransactionId,
                                     DX_TRUE,/*reflash sensitive*/
                                     TST_Workspace,
                                     TST_WorkspaceSizeInBytes);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);


     /* Delete the session */
     /*--------------------*/
     TST_Status = SST_SessionDelete(TST_SessionId);

     TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                                "SEPQA_SST_BasicDataOp",TST_MasterTestName);


     EXIT_ON_ERROR:
       return TST_Status;
}/* End of SST_TST_ATP_SpecialDataOpAES */

/*****************************************************************************
 * Function Name:
 *  SST_TST_ATP_SpecialDataOpDES
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 * Test the Test the insertion, generation, reading, deletion, and usage of a DES symmetric key.
 *  
 * Algorithm:       
 *    1.  Create a new session by calling: SST_SessionCreate.
 *    2.  Open a transaction by calling: SST_TransactionStart.
 *    3.  Create a new password authenticator by calling: SST_AuthenticatorPasswordCreate.
 *    4.  Close the transaction by calling: SST_TransactionEnd.
 *    5.  Open the authenticator by calling: SST_AuthenticationOpen.
 *    6.  Open a transaction by calling: SST_TransactionStart.
 *    7.  Create a new DES #1 key by calling: SST_DESKeyGenerate.
 *    8.  Read the generated DES key #1 by calling: SST_DESKeyRead.
 *    9.  Insert a DES #2 key to the SST by calling: SST_DESKeyInsert. Using the data received by reading the SST key #1
 *    10.  Read the inserted DES key #2 by calling: SST_DESKeyRead. And compare to data used.
 *    11.  Close the transaction by calling: SST_TransactionEnd.
 *    12.  Encrypt plain text by using DES key #1 and calling: CRYS_SST_DES.
 *    13.  Decrypt the received cipher text using DES key #2 by calling: CRYS_SST_DES and compare to the original plain text.
 *    14.  Open a transaction by calling: SST_TransactionStart.
 *    15.  Delete the DES keys (one by one) by calling: SST_DataDelete.
 *    16.  Close the authenticator by calling: SST_AuthenticationClose.
 *    17.  Delete the authenticator by calling: SST_AuthenticatorDelete.
 *    18.  Close the transaction by calling: SST_TransactionClose.
 *    19.  Delete the session by calling: SST_SessionDelete.
 *
 *******************************************************************************/    
DxError_t SEPQA_SST_SpecialDataOpDES ( void )
{ 
   /********* TST Variables Definitions ************/
    DxUint32_t                  TST_index=0;
    DxChar                      TST_MasterTestName[TST_FUNC_STRING_LEN] = "SEPQA_SST_ATP_SpecialDataOpAES";
    SSTSessionId_t              TST_SessionId; 
    SSTTxnId_t                  TST_TransactionId;
    SSTHandle_t                 TST_AuthHandle,TST_DESKeyHandle1,TST_DESKeyHandle2;
    SSTDataType_t               TST_DESKeyData = TST_DESKEY_OBJECT;
    SSTHandle_t                 TST_AuthDefaultHandle;
    DxError_t                   TST_Status;

    /********* TST Variables initialization *********/
    TST_Status = TESTPASS;
    TST_DESKeyHandle1.objId = SST_HANDLE_RANDOM_GENERATE;
    TST_DESKeyHandle2.objId = SST_HANDLE_RANDOM_GENERATE;
    TST_AuthHandle.objId = SST_HANDLE_RANDOM_GENERATE;


    /************************************************/
    /*********** Start of test **********************/
    /************************************************/
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," *************** SEPQA_SST_SpecialDataOpDES Tests ***************** \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ****************************************************************** \n \n"));

    ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," TEST using internal handles          \n"));
    ATP_LOG_TST_PRINT((SST_TST_MSG," ************************************ \n"));

    /* Create a session for operations */
    /*---------------------------------*/
    TST_Status = SST_SessionCreate(&TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionCreate",
                               TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);
    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                        TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                        TST_MasterTestName);


     /* Create a new password authenticator */
     /*-------------------------------------*/
    TST_AuthDefaultHandle.objDigest = 0;
    TST_AuthDefaultHandle.objId = SST_CLOSE_AUTH_HANDLE;

    TST_Status = SST_AuthenticatorPasswordCreate(TST_TransactionId,
                                                TST_SessionId,
                                                TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Password,
                                                TST_ATP_SpecialDataOpDESTestData[TST_index].TST_PasswordSizeInBytes,
                                                TST_ATP_SpecialDataOpDESTestData[TST_index].TST_MaxNumOfTrials,
                                                TST_AuthDefaultHandle,
                                                &TST_AuthHandle,
                                                TST_Workspace,
                                                TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorPasswordCreate",
                        TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                        TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                    TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                        TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                        TST_MasterTestName);


    /* Open the password authentication */
    /*----------------------------------*/
    TST_Status = SST_AuthenticationOpen(TST_SessionId,
                                       TST_AuthHandle,
                                       TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Password,
                                       TST_ATP_SpecialDataOpDESTestData[TST_index].TST_PasswordSizeInBytes,
                                       TST_NO_CHALLENGE,
                                       TST_Workspace,
                                       TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationOpen",
                        TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                        TST_MasterTestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                        TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                        TST_MasterTestName);


    /* Create a new DES key #1 */
    /*-------------------------*/
    TST_Status = SST_DESKeyGenerate(TST_TransactionId,
                                   TST_SessionId,
                                   TST_AuthHandle,
                                   TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DESKeyType1,
                                   TST_DESKeyData,
                                   &TST_DESKeyHandle1,
                                   TST_Workspace,
                                   TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DESKeyGenerate",
                        TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                        TST_MasterTestName);


    /* Verify the type of DES key #1 */
    /*-------------------------------*/
    TST_Status = SST_DESKeyRead(TST_SessionId,
                               TST_DESKeyHandle1,   
                               TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DESKey2,
                               &TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DESKeyType2,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DESKeyRead - Get key type",
                        TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                        TST_MasterTestName);


    if (TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DESKeyType2 != TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DESKeyType1)
        TST_Status = DX_FALSE;

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"Validate key type - DES",
                  TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                  TST_MasterTestName);


    /* Insert DES Key #2 */
    /*-------------------*/
    TST_Status = SST_DESKeyInsert(TST_TransactionId,
                                 TST_SessionId,
                                 TST_AuthHandle,
                                 TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DESKey2,
                                 TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DESKeyType2,
                                 TST_DESKeyData,
                                 &TST_DESKeyHandle2,
                                 TST_Workspace,
                                 TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DESKeyInsert - Key #2",
                  TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                  TST_MasterTestName);


    /* Read DES key #2 */
    /*-----------------*/
    TST_Status = SST_DESKeyRead(TST_SessionId,
                               TST_DESKeyHandle2,   
                               TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DESKeyTemp,
                               &TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DESKeyTypeTemp,
                               TST_Workspace,
                               TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DESKeyRead #2",
                  TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                  TST_MasterTestName);


    /* Compare the retrieved key to inserted one */
    /*-------------------------------------------*/
    if(!DX_VOS_MemCmp(TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DESKey2,
                      TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DESKeyTemp,
                      TST_ATP_SpecialDataOpDESTestData[TST_index].TST_KeySizeInBytes))
        TST_Status = TESTPASS; /*Data Buffers are the same*/
    else
         TST_Status = TESTFAIL; /*Data Buffers are different*/

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - keys",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
                                    DX_TRUE,/*reflash sensitive*/
                                    TST_Workspace,
                                   TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                        TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                        TST_MasterTestName);


     /* Encrypt a block of data using key #1 */
     /*--------------------------------------*/
     TST_Status = CRYS_SST_DES(TST_DESKeyHandle1,
                              TST_SessionId,
                              TST_ATP_SpecialDataOpDESTestData[TST_index].TST_IVCounter,
                              CRYS_DES_Encrypt, 
                              TST_ATP_SpecialDataOpDESTestData[TST_index].TST_OperationMode,
                              TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DataIn,
                              TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DataInSize,
                              TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DataOut,
                              TST_Workspace,
                              TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_DES - Encrypt",
                        TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                        TST_MasterTestName);


    /* Decrypt the block of data using key #2 */
    /*----------------------------------------*/
    TST_Status = CRYS_SST_DES(TST_DESKeyHandle2,
                             TST_SessionId,
                             TST_ATP_SpecialDataOpDESTestData[TST_index].TST_IVCounter,
                             CRYS_DES_Decrypt, 
                             TST_ATP_SpecialDataOpDESTestData[TST_index].TST_OperationMode,
                             TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DataOut,
                             TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DataInSize,
                             TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DataOutDecrypt,
                             TST_Workspace,
                             TST_WorkspaceSizeInBytes);

      TST_ATP_CHECK_ERROR_RETURN(TST_Status,"CRYS_SST_DES - Decrypt",
                          TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                          TST_MasterTestName);


    /* Compare the decrypted data to original one */
    /*--------------------------------------------*/
    if(!DX_VOS_MemCmp(TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DataIn,
                      TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DataOutDecrypt,
                      TST_ATP_SpecialDataOpDESTestData[TST_index].TST_DataInSize))
        TST_Status = TESTPASS; /*Data Buffers are the same*/
    else
        TST_Status = TESTFAIL; /*Data Buffers are different*/

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"DX_VOS_MemCmp - Decrypted data",
                        TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                        TST_MasterTestName);


    /* Open a transaction for operations */
    /*-----------------------------------*/
    TST_Status = SST_TransactionStart(&TST_TransactionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionStart",
                        TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                        TST_MasterTestName);


    /* Delete the DES keys */
    /*---------------------*/
    TST_Status = SST_DataDelete(TST_TransactionId,
                                TST_SessionId,  
                                TST_DESKeyHandle1,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - DES key #1",
                  TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                  TST_MasterTestName);


    TST_Status = SST_DataDelete(TST_TransactionId,
                                TST_SessionId,  
                                TST_DESKeyHandle2,
                                TST_Workspace,
                                TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_DataDelete - DES key #2",
                               TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                               TST_MasterTestName);


    /* Close the authentication */
    /*--------------------------*/
    TST_Status = SST_AuthenticationClose(TST_SessionId,TST_AuthHandle);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticationClose",
                        TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                        TST_MasterTestName);


    /* Delete the authenticator */
    /*--------------------------*/
    TST_Status = SST_AuthenticatorDelete(TST_TransactionId,
                                        TST_AuthHandle);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_AuthenticatorDelete",
                        TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                        TST_MasterTestName);


    /* Close the transaction */
    /*-----------------------*/
    TST_Status = SST_TransactionEnd(TST_TransactionId,
               DX_TRUE,/*reflash sensitive*/
               TST_Workspace,
                                   TST_WorkspaceSizeInBytes);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_TransactionEnd",
                        TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                        TST_MasterTestName);


    /* Delete the session */
    /*--------------------*/
    TST_Status = SST_SessionDelete(TST_SessionId);

    TST_ATP_CHECK_ERROR_RETURN(TST_Status,"SST_SessionDelete",
                        TST_ATP_SpecialDataOpDESTestData[TST_index].TST_Name,
                        TST_MasterTestName);





  EXIT_ON_ERROR:

    return TST_Status;

}/* End of SEPQA_SST_SpecialDataOpDES */


